/*
 * Decompiled with CFR 0.152.
 */
package net.endil.farmersutils.data;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.endil.farmersutils.common.registry.FUBlocks;
import net.endil.farmersutils.common.registry.FUItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.data.ItemModels;

public class FUItemModels
extends ItemModelProvider {
    public FUItemModels(DataGenerator output, ExistingFileHelper existingFileHelper) {
        super(output, "farmersutils", existingFileHelper);
    }

    protected void registerModels() {
        Set items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "farmersutils".equals(ForgeRegistries.ITEMS.getKey(i).m_135827_())).collect(Collectors.toSet());
        items.remove(FUItems.EGG_BOX.get());
        this.spriteModel(FUBlocks.EGG_BOX);
        items.remove(FUItems.CRATE.get());
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        for (RegistryObject itemRegistryObject : Arrays.asList(FUItems.APPLE_SLICE, FUItems.GOLDEN_APPLE_SLICE, FUItems.DRIED_APPLE_SLICE, FUItems.DRIED_GOLDEN_APPLE_SLICE, FUItems.DRIED_BEEF, FUItems.DRIED_CHICKEN, FUItems.DRIED_COD_SLICE, FUItems.DRIED_MUTTON, FUItems.DRIED_PORKCHOP, FUItems.DRIED_RABBIT, FUItems.DRIED_SALMON_SLICE, FUItems.BOILED_EGG)) {
            this.simpleModel((RegistryObject<Item>)itemRegistryObject);
        }
    }

    private ItemModelBuilder simpleModel(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersutils", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder handheldModel(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersutils", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder spriteModel(RegistryObject<Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersutils", "item/" + block.getId().m_135815_()));
    }

    private ItemModelBuilder plantModel(RegistryObject<Block> plant) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(plant.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersutils", "block/" + plant.getId().m_135815_()));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    private String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("farmersutils", "block/" + path);
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("farmersutils", "item/" + path);
    }
}

